/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.ats.modelo.util.Util;
import java.math.BigDecimal;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValoresComprobante
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<ValoresComprobante>,
Importable {
    private static final long serialVersionUID = -9008284115775171769L;
    public static final String C_BASE_IVA_CERO = "baseIvaCero";
    public static final String C_MONTO_ICE = "montoIce";
    @NotNull(message="Debe ingresar el valor de Tarifa IVA 0% ")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Tarifa IVA 0%  debe ser 12 enteros y 2 decimales. ")
    private String baseIvaCero = "0.00";
    @NotNull(message="Debe ingresar el valor de Monto Retenido ICE")
    @Pattern(regexp="^((0{1})|(([1-9]{1}))([0-9]{0,11}))(\\.[0-9]{2})?$", message="El valor Monto Retenido ICE debe ser 12 enteros y 2 decimales. ")
    private String montoIce = "0.00";
    protected BigDecimal retencionIvaBienesCalculado = BigDecimal.ZERO;
    protected BigDecimal retencionIvaServiciosCalculado = BigDecimal.ZERO;
    protected BigDecimal retencionIvaCienCalculado = BigDecimal.ZERO;
    protected BigDecimal retencionIva20Calculado;
    protected BigDecimal retencionIva10Calculado;
    protected BigDecimal retencionIva50Calculado;
    protected BigDecimal retencionIvaNCCalculado;
    private BigDecimal sumaRetenciones = BigDecimal.ZERO;
    private BigDecimal sumaBasesImponibles = BigDecimal.ZERO;
    private BigDecimal montoIvaCalculado = BigDecimal.ZERO;
    private BigDecimal totalSumaFormasPago = BigDecimal.ZERO;

    public ValoresComprobante() {
        this.retencionIvaNCCalculado = BigDecimal.ZERO;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if (this.validarMontoIce(resultado).esEstadoFallido()) {
            return resultado;
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso() && resultado.esEstadoFallido()) {
            return resultado;
        }
        return resultado.esEstadoExitoso() ? resultado.pasarValidacion() : resultado;
    }

    public ValoresComprobante crearCopiaEdicion() {
        ValoresComprobante copia = new ValoresComprobante();
        copia.setBaseIvaCero(this.baseIvaCero);
        copia.setMontoIce(this.montoIce);
        copia.setRetencionIvaBienesCalculado(this.retencionIvaBienesCalculado);
        copia.setRetencionIvaServiciosCalculado(this.retencionIvaServiciosCalculado);
        copia.setRetencionIvaCienCalculado(this.retencionIvaCienCalculado);
        copia.setMontoIvaCalculado(this.montoIvaCalculado);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(ValoresComprobante copiaEdicion) {
        this.setBaseIvaCero(copiaEdicion.getBaseIvaCero());
        this.setMontoIce(copiaEdicion.getMontoIce());
    }

    protected ResultadoValidacion validarMontoIce(ResultadoValidacion resultado) {
        if (Util.getBigDecimal(this.getMontoIce()).compareTo(this.getSumaBasesImponibles()) == 1) {
            return resultado.fallarValidacion("El valor Monto ICE debe ser menor o igual a la suma de las Bases Imponibles.");
        }
        return resultado;
    }

    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        return resultado;
    }

    protected void sumarBasesImponibles(String ... valores) {
        this.sumaBasesImponibles = Util.sumarValores(valores);
    }

    protected void sumarRetenciones(String ... valores) {
        this.sumaRetenciones = Util.sumarValores(valores);
    }

    protected void sumarMontoFormasPago(String ... valores) {
        this.totalSumaFormasPago = Util.sumarValores(valores);
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName("baseImponible");
        Element eValor = (Element)valorList.item(0);
        this.baseIvaCero = eValor.getTextContent();
        valorList = elemento.getElementsByTagName(C_MONTO_ICE);
        eValor = (Element)valorList.item(0);
        this.montoIce = eValor.getTextContent();
        return this;
    }

    public String getBaseIvaCero() {
        return this.baseIvaCero;
    }

    public String getMontoIce() {
        return this.montoIce;
    }

    public BigDecimal getSumaBasesImponibles() {
        return this.sumaBasesImponibles;
    }

    public String getSumaBasesImponiblesInterfaz() {
        return String.valueOf(this.sumaBasesImponibles);
    }

    protected BigDecimal getRetencionIvaBienesCalculado() {
        return this.retencionIvaBienesCalculado;
    }

    protected BigDecimal getRetencionIvaServiciosCalculado() {
        return this.retencionIvaServiciosCalculado;
    }

    protected BigDecimal getRetencionIvaCienCalculado() {
        return this.retencionIvaCienCalculado;
    }

    protected BigDecimal getMontoIvaCalculado() {
        return this.montoIvaCalculado;
    }

    public BigDecimal getSumaRetenciones() {
        return this.sumaRetenciones;
    }

    public BigDecimal getTotalSumaFormasPago() {
        return this.totalSumaFormasPago;
    }

    public BigDecimal getRetencionIvaNCCalculado() {
        return this.retencionIvaNCCalculado;
    }

    public void setBaseIvaCero(String baseIvaCero) {
        String oldValue = this.baseIvaCero;
        this.baseIvaCero = baseIvaCero;
        this.firePropertyChange(C_BASE_IVA_CERO, oldValue, this.baseIvaCero);
    }

    public void setMontoIce(String montoIce) {
        String oldValue = this.montoIce;
        this.montoIce = montoIce;
        this.firePropertyChange(C_MONTO_ICE, oldValue, this.montoIce);
    }

    protected void setRetencionIvaBienesCalculado(BigDecimal retencionIvaBienesCalculado) {
        this.retencionIvaBienesCalculado = retencionIvaBienesCalculado;
    }

    protected void setRetencionIvaServiciosCalculado(BigDecimal retencionIvaServiciosCalculado) {
        this.retencionIvaServiciosCalculado = retencionIvaServiciosCalculado;
    }

    protected void setRetencionIvaCienCalculado(BigDecimal retencionIvaCienCalculado) {
        this.retencionIvaCienCalculado = retencionIvaCienCalculado;
    }

    protected void setMontoIvaCalculado(BigDecimal montoIvaCalculado) {
        this.montoIvaCalculado = montoIvaCalculado;
    }

    public void setRetencionIvaNCCalculado(BigDecimal retencionIvaNCCalculado) {
        this.retencionIvaNCCalculado = retencionIvaNCCalculado;
    }
}

